
#ifndef CRYS_HOST_TST_RC4
#define CRYS_HOST_TST_RC4

/***************************************************************** 
*  @file CRYS_HOST_TST_RC4.c
*  @brief Functions used for HOST-SEP communication to send message from HOST to SEP
*         that contains requested API to be executed in SEP and API parameters
*         Used for SEP External application ATP testing.
*
*  @author mottig
*  @remarks Copyright (C) 2004 by Discretix Technologies Ltd.
*           All Rights reserved
*/

/************************ Includes *****************************/
#include "DX_VOS_BaseTypes.h"
#include "ExtApp_CRYS_Defines.h"
#include "CRYS.h"

#ifdef __cplusplus
extern "C"
{
#endif


/************************ Defines ******************************/



/************************ Enums ********************************/

/************************ Typedefs  ****************************/

/************************Public Variables **********************/

/*********************** Public Functions **********************/

/***********************************************************************
* Function Name:                                                           
*  SEPQA_RC4_NotIntegrated         
* 
* Inputs:
* Inputs:
* Key_ptr -  A pointer to the user's key buffer.
* KeySize - The size of the KEY in bytes.
* EncryptDecryptFlag - flag to execute encrypt/decrypt
* OutputLocation - indication if input buffer == output buffer or not.* 
* DataIn_ptr - The pointer to the buffer of the input data.
* DataInSize - The size of the data to be hashed in bytes. On CSI data transfer mode the size must  
*                         multiple of HASH_BLOCK_SIZE for used HASH mode.
*
* DataExpSize - The size of the expected data
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
*
* Outputs:
*  CRYSError_t - Function error return                                     
*
* Description:
*  This function is used to operate the qa external application on the SEP, 
*  that executes HMAC not integrated test
* Algorithm:       
* 1. initiate and start the message 
* 2. prepare message with all non buffer parameters of the API
* 3. send all buffers params                                   
* 4. end message
* 5. wait for the response of SEP side
* 6. start reading message from the SEP  and check returned function status from SEP
*
**************************************************************************/                                
EXPORT_C DxUint32 SEPQA_RC4_NotIntegrated(
									DxUint8_t 		*Key_ptr,
									DxUint16_t		KeySize,
									DxUint8_t       EncryptDecryptFlag,
									DxUint8_t       OutputLocation,
									DxUint8_t       *DataIn_ptr,
									DxUint32_t      DataInSize,
									DxUint8_t       *ExpectedData_ptr,        
									DxUint32_t      DataExpSize,
									char           *FailureFunctionNameOut_ptr,
        						    DxUint32_t      FuncNameMaxSize);
        								   
/***********************************************************************
* Function Name:                                                           
*  SEPQA_RC4_Integrated         
* 
* Inputs:
* Inputs:
* Key_ptr -  A pointer to the user's key buffer.
* KeySize - The size of the KEY in bytes.
* EncryptDecryptFlag - flag to execute encrypt/decrypt
* OutputLocation - indication if input buffer == output buffer or not.* 
* DataIn_ptr - The pointer to the buffer of the input data.
* DataInSize - The size of the data to be hashed in bytes. On CSI data transfer mode the size must  
*                         multiple of HASH_BLOCK_SIZE for used HASH mode.
*
* DataExpSize - The size of the expected data
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
*
* Outputs:
*  CRYSError_t - Function error return                                     
*
* Description:
*  This function is used to operate the qa external application on the SEP, 
*  that executes HMAC not integrated test
* Algorithm:       
* 1. initiate and start the message 
* 2. prepare message with all non buffer parameters of the API
* 3. send all buffers params                                   
* 4. end message
* 5. wait for the response of SEP side
* 6. start reading message from the SEP  and check returned function status from SEP
*
**************************************************************************/                                
EXPORT_C DxUint32 SEPQA_RC4_Integrated(
									DxUint8_t 		*Key_ptr,
									DxUint16_t		KeySize,
									DxUint8_t       EncryptDecryptFlag,
									DxUint8_t       OutputLocation,
									DxUint8_t       *DataIn_ptr,
									DxUint32_t      DataInSize,
									DxUint8_t       *ExpectedData_ptr,        
									DxUint32_t      DataExpSize,
									char           *FailureFunctionNameOut_ptr,
        						    DxUint32_t      FuncNameMaxSize);
        								   
									  

#ifdef __cplusplus
}
#endif

#endif  /* CRYS_HOST_TST_RC4 */
